# Open Data files for Decidim Lunel


This ZIP file contains files for studying and researching about this participation platform.


## Core

### users

* id: L'identifiant unique de l'utilisateur
* name: The display name of user
* nickname: Le pseudonyme de l'utilisateur
* about: Le champ "À propos" de l'utilisateur
* avatar_url: L'avatar de l'utilisateur
* profile_url: L'url du profil
* direct_messages_enabled: Whether the user allows direct messages
* deleted: Whether the user is deleted or not
* badge: Le badge de l'utilisateur
* groups: L'identifiant et le nom du groupe d'utilisateurs


### user_groups

* id: L'identifiant unique du groupe d'utilisateurs
* name: Le nom du groupe d'utilisateurs
* nickname: Le nom d'utilisateur du groupe d'utilisateurs
* avatar_url: L'avatar du groupe d'utilisateurs
* profile_url: L'url du profil
* deleted: Whether the user is deleted or not
* badge: Le badge du groupe d'utilisateurs
* members_count: Le nombre d'utilisateurs appartenant au groupe d'utilisateurs
* members: L'id et le nom des utilisateurs appartenant au groupe


### metrics

* day: Le jour de la création de cette métrique
* metric_type: Le type de métrique
* cumulative: The total number of the metric at this day
* quantity: Le nombre de métriques pour ce jour


### taxonomies

* id: The unique identifier of this taxonomy
* name: The name of this taxonomy
* parent_id: The unique identifiers of this taxonomy parent (if any)
* weight: The order in which this taxonomy is shown
* children_count: The count of the children that this taxonomy has
* taxonomizations_count: The count of the resources that use this taxonomy
* created_at: The date when this taxonomy was created
* updated_at: The date when this taxonomy was updated for the last time
* filters_count: The number of filters that is using this taxonomy
* filter_items_count: The number of items filters that are using this taxonomy
* part_of: Used to detect if this taxonomy is part of another taxonomy
* is_root: True if this taxonomy do not have any parent



## Espaces

### participatory_processes

* id: The unique identifier of this process
* title: The process title
* slug: The process slug (used for identification purposes, for the URL)
* reference: The unique reference of the space
* created_at: The date this space was created
* updated_at: La dernière date de mise à jour de cet espace
* published_at: The date this space was published
* follows_count: The number of users following this space
* hashtag: The process hashtag, used for Twitter/X
* short_description: A short description of the process
* description: A long description of the process
* promoted: Wheter the process is promoted or not
* url: L'URL de l'espace
* subtitle: The subtitle of the process
* remote_hero_image_url: The URL of the process hero image
* announcement: The announcement (callout) information
* start_date: The start date of the process
* end_date: The end date of the process
* developer_group: The developer group of the process. This is the organization that is promoting the process.
* local_area: The local area of the process. This is the organization area where the process is taking place.
* meta_scope: The scope metadata of the process
* participatory_scope: The participatory scope of the process
* participatory_structure: The participatory structure of the process. This is how the process is decided.
* target: The target of the process. This is who is called to participate in the process.
* area: The area where the process is taking place
* participatory_process_group: The group of the process, if there is any
* scope: The scope of the process
* scopes_enabled: Whether the scopes are enabled or not
* participatory_process_type: The type of the process


### assemblies

* id: The unique identifier of this assembly
* title: The assembly title
* slug: The assembly slug (used for identification purposes, for the URL)
* reference: The unique reference of the space
* created_at: La date de création de cet espace
* updated_at: The last date this space was updated
* published_at: The date this space was published
* follows_count: The number of users following this space
* hashtag: The assembly hashtag, used for Twitter/X
* short_description: A short description of the assembly
* description: A long description of the assembly
* promoted: Wheter the assembly is promoted or not
* url: The URL of the space
* subtitle: The subtitle of the assembly
* remote_hero_image_url: The URL of the assembly hero image
* remote_banner_image_url: The URL of the assembly banner image
* announcement: Information sur l'annonce (callout)
* developer_group: The developer group of the assembly
* local_area: The local area of the assembly
* meta_scope: The scope metadata of the assembly
* participatory_scope: The participatory scope of the assembly
* purpose_of_action: The purpose of action of the assembly
* composition: La composition de l'assemblée
* duration: The duration of the assembly
* participatory_structure: The participatory structure of the assembly
* target: The target of the assembly
* decidim_scope_id: The scope of the assembly
* area: The area of the assembly
* scope: The scope of the assembly
* scopes_enabled: Weather the scopes are enabled or not
* included_at: The date when the assembly was included
* closing_date: La date de clôture de l'assemblée
* created_by: Qui a créé cette assemblée
* creation_date: The date of creation of this assembly
* closing_date_reason: Pourquoi l'assemblée a été clôturée
* internal_organisation: The internal organisation of this assembly
* is_transparent: Where the assembly is transparent or not
* special_features: Which special features this assembly has
* twitter_handler: Social media handler for Twitter
* instagram_handler: Social media handler for Instagram
* facebook_handler: Social media handler for Facebook
* youtube_handler: Social media handler for YouTube
* github_handler: Social media handler for GitHub
* created_by_other: Other creator of the assembly
* assembly_type: Le type de l'assemblée



## Fonctionnalités

### debates

* id: L'identifiant unique du débat
* author: The data for the author of this debate
* title: Le titre du débat
* description: La description du débat
* instructions: Which are the instructions to comment in this debate
* start_time: When this debate starts, if it is an open debate and has a limited time
* end_time: When this debate ends, if it is an open debate and has a limited time
* information_updates: The updates that the author has made to the debate
* taxonomies: The taxonomies of the project
* participatory_space: To which space (e.g. Participatory Process, or Assembly) this debate belongs to
* component: The component that the debate belongs to
* reference: The unique identifier of the resource in this platform
* comments: The number of comments this debate has
* follows_count: Le nombre de personnes qui suivent ce débat
* url: The URL where this debate can be found
* last_comment_at: The date when this debate was commented by the last time
* last_comment_by: Les données du dernier commentaire du débat
* comments_enabled: Wether this debate has comments enabled or not
* conclusions: Les conclusions du débat s'il est clos
* closed_at: La date de clôture de ce débat
* created_at: La date et l'heure de création du débat
* updated_at: La date de la dernière mise à jour du débat
* endorsements_count: Le nombre de soutiens au débat


### debate_comments

* id: L'identifiant de ce commentaire
* created_at: La date de création de ce commentaire
* body: Le commentaire lui-même
* locale: The locale (language) that the participant had when leaving this comment
* author: Le nom du participant qui a fait ce commentaire
* alignment: If this comment was a favour, against or neutral
* depth: The place where this comment is in the three of comments (if it is an answer or an answer of an answer)
* user_group: The name of the user group that made this comment (if any)
* commentable_id: The unique id of the commentable
* commentable_type: The type of the commentable (if it was a result, a proposal, etc.)
* root_commentable_url: The URL of the resource that ties to this comment


### meetings

* id: L'identifiant unique de la rencontre
* author: Les données pour l'auteur de cette rencontre
* participatory_space: À quel espace (par exemple : Processus participatif, ou Assemblée) appartient cette rencontre
* taxonomies: Les taxonomies auxquelles appartient cette rencontre
* component: Le composant auquel appartient la rencontre
* title: Le titre de la rencontre
* description: La description de la rencontre
* start_time: La date et l'heure de début de la rencontre
* end_time: La date et l'heure de fin de cette rencontre
* attendees: Le nombre de personnes participant à cette rencontre
* contributions: Le nombre de contributions apportées à cette rencontre par les participants
* organizations: Les organisations qui participent à cette rencontre
* address: L'adresse de la rencontre au cas où elle se déroule en présentiel
* location: La localisation de la rencontre
* reference: L'identifiant unique de la ressource sur cette plateforme
* attachments: Le nombre de pièces jointes dans cette rencontre
* url: L'URL de la rencontre
* related_proposals: Les propositions relatives à cette rencontre
* related_results: Les résultats de cette rencontre
* published: Quand la rencontre a été publiée
* withdrawn: Si cette rencontre a été annulée
* withdrawn_at: Quand cette rencontre a été retirée
* location_hints: Un indice de l'endroit où se déroule la rencontre
* created_at: La date de création de la rencontre
* updated_at: La date et l'heure auxquelles la rencontre a été mise à jour
* latitude: La latitude de la rencontre
* longitude: La longitude de la rencontre
* follows_count: Le nombre de personnes qui suivent cette rencontre
* private_meeting: Pour indiquer si la rencontre est privée ou non
* transparent: La visibilité de la rencontre pour les non-membres
* registration_form_enabled: Si le formulaire d'inscription a été activé ou non
* comments: Les données des commentaires de la rencontre
* online_meeting_url: L'URL de la rencontre en ligne
* closing_visible: La clôture de la rencontre est visible
* closing_report: Rapport de la rencontre clôturée
* attending_organizations: Les organisations participant à la réunion
* registration_url: URL de l'inscription à la rencontre
* decidim_user_group_id: User group ID of people involved in the meeting
* decidim_author_type: Type d'auteur de la rencontre
* video_url: Enregistrement vidéo de la rencontre
* audio_url: Enregistrement audio de la rencontre
* closed_at: La date à laquelle la rencontre s'est terminée
* registration_terms: Les conditions convenues avant la participation à la rencontre
* available_slots: Le nombre de places disponibles dans une rencontre
* registrations_enabled: Si les inscriptions ont été autorisées
* customize_registration_email: La possibilité d'autoriser un e-mail personnalisé lors de l'inscription
* type_of_meeting: Le type de rencontre
* iframe_access_level: The iframe access level of the meeting
* iframe_embed_type: Le type d'iframe inclus dans la rencontre
* reserved_slots: Le nombre de places réservées que la rencontre a
* registration_type: Le type d'inscription à la rencontre


### pages

* id: L'identifiant unique de cette page
* title: Le titre de la page
* body: Le corps de la page
* created_at: La date de création de cette page
* updated_at: La dernière date de mise à jour de cette page
* participatory_space: À quel espace appartient la page (par exemple Processus participatif, ou Assemblée)
* component: Le composant auquel appartient la page
* url: L'URL de cette page


### proposals

* id: The unique identifier for the proposal
* author: The data for the author of this proposal
* taxonomies: The taxonomies that this proposal belongs to
* participatory_space: To which space (e.g. Participatory Process, or Assembly) this proposal belongs to
* component: The component that the proposal belongs to
* title: The proposal title
* body: The proposal body
* address: The address of the proposal in case the proposal has a physical location
* latitude: The latitude of the proposal in case it has a physical location
* longitude: The longitude of the proposal in case it has a physical location
* state: The status of this proposal (e.g. "Accepted")
* state_published_at: Un horodatage de l'état de la proposition lorsqu'elle est publiée
* reference: The unique identifier of the resource in this platform
* answer: The answer to the proposal in the case it has been answered
* answered_at: The date when this proposal was answered
* votes: The number of votes this proposal has
* endorsements: The number of endorsements ("likes") this proposal has
* comments: The number of comments this proposal has
* attachments: The number of attachments this proposal has
* follows_count: Le nombre de personnes qui suivent cette proposition
* published_at: The date when this proposal was published
* url: The URL where this proposal can be found
* meeting_urls: The URLs of the meetings where this proposal was presented or discussed in
* related_proposals: The proposals related to this proposal
* is_amend: Wheter this proposal is ammedning another proposal
* original_proposal: The reference of the original proposal if this is an amendment
* withdrawn: Wheter this proposal has been withdrawn
* withdrawn_at: When this proposal was withdrawn
* created_at: La date de création de la proposition
* updated_at: La date de la dernière mise à jour de la proposition
* created_in_meeting: Si la proposition a été créée dans une réunion
* coauthorships_count: Le nombre de coauteurs que la proposition représente
* cost: Le coût total de la proposition en question
* cost_report: Un rapport sur les coûts de la proposition
* execution_period: La période à laquelle la proposition s'est déroulée du début à la fin



